import { markRaw } from 'vue'

import Microsoft from '@inside-auth/components/login/extra-component/Microsoft'

const origin = new URL(
  process.env.NODE_ENV === 'development'
    ? JSON.parse(process.env.GLOBAL).localURL
    : window.location
).origin

export default {
  'inside-auth': {
    extraComponent: {
      is: markRaw(Microsoft),
      link: `${origin}/saml/login`
    }
  },
  'inside-commons': {
    banner: {
      darkMode: false
    }
  },
  'inside-users': {
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/UserCard'),
        requestFields: [
          'uuid',
          'email',
          'services',
          'firstname',
          'lastname',
          'image'
        ]
      }
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'shortcuts', restrictions: [], icon: 'news' }
      ]
    }
  }
}
