import { withFetch } from 'inside-collection/hocs'

import SpacePage from '../pages/spaces/SpacePage'
import SpacesPagesListingPage from '../pages/spaces/SpacesPagesListingPage'
import TabsSpacePage from '../pages/tabs_spaces/TabsSpacePage'
import { fetchSimpleSpace, fetchSpace, fetchTabsSpace } from '../fetch'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

import { CONTENTS } from '@inside-ged/constants/default-contents'
const folderContents = CONTENTS()

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      folderTypes: {
        ...folderContents.folders,
        filters: {
          'status:eq': 1,
          sort: 'weight:asc'
        },
        fields: folderContents.folders.fields
      }
    }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/users/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false, content: 'pages' }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'SpacePage',
    component: withFetch(SpacePage, { size: 'xxl', watch: true })(fetchSpace),
    path: '/espaces/:slug'
  },
  {
    name: 'SpacesPagesListingPage',
    component: withFetch(SpacesPagesListingPage, { size: 'xxl', watch: true })(
      fetchSimpleSpace
    ),
    path: '/espaces/:slug/pages'
  },
  {
    name: 'TabsSpacePage',
    component: withFetch(TabsSpacePage, { size: 'xxl', watch: true })(
      fetchTabsSpace
    ),
    path: '/espaces-onglet/:slug/pages',
    meta: {
      disabled: false
    }
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
