import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    }),
    delete: async data => ({
      name: 'Homepage'
    })
  },
  spacesPages: {
    add: async ({ data }) => {
      const { data: pages } = await http.get('content/spaces_pages', {
        fields: [{ pages_categories: [{ spaces: ['slug'] }] }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacesPagesListingPage',
        params: { slug: pages[0]?.pages_categories.spaces.slug[0] },
        query: { page: data.uuid }
      }
    },
    delete: async data => {
      const { data: pages } = await http.get('content/spaces_pages', {
        fields: [{ pages_categories: [{ spaces: ['slug'] }] }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacePage',
        params: { slug: pages[0].pages_categories.spaces.slug[0] }
      }
    }
  },
  pagesCategories: {
    add: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: [{ spaces: { fields: ['slug'] } }],
          filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
        }
      )

      return {
        name: 'SpacesPagesListingPage',
        params: {
          slug: pagesCategories[0].spaces.slug[0]
        }
      }
    },
    delete: async data => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: [{ spaces: { fields: ['slug'] } }],
          filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
        }
      )

      return {
        name: 'SpacePage',
        params: { slug: pagesCategories[0].spaces.slug[0] }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: [{ spaces: ['slug'] }],
          filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
        }
      )

      return {
        route: {
          name: 'SpacesPagesListingPage',
          params: {
            slug: pagesCategories[0].spaces.slug[0]
          }
        }
      }
    }
  },
  tabsSpaces: {
    add: ({ data }) => ({
      name: 'TabsSpacePage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'HomePage'
    })
  },
  tabs: {
    add: async ({ data }) => {
      const { data: tabs } = await http.get('content/tabs', {
        fields: [{ tabs_spaces: { fields: ['slug'] } }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'TabsSpacePage',
        params: {
          slug: tabs[0].tabs_spaces.slug[0]
        }
      }
    },
    delete: async data => {
      const { data: tabs } = await http.get('content/tabs', {
        fields: [{ tabs_spaces: { fields: ['slug'] } }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'TabsSpacePage',
        params: {
          slug: tabs[0].tabs_spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: tabs } = await http.get('content/tabs', {
        fields: [{ tabs_spaces: { fields: ['slug'] } }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'TabsSpacePage',
          params: {
            slug: tabs[0].tabs_spaces.slug[0]
          }
        }
      }
    }
  },
  tabsPages: {
    add: async ({ data }) => {
      const { data: pages } = await http.get('content/tabs_pages', {
        fields: [{ tabs: [{ tabs_spaces: ['slug'] }] }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'TabsSpacePage',
        params: { slug: pages[0]?.tabs.tabs_spaces.slug[0] },
        query: { page: data.uuid }
      }
    },
    delete: async data => {
      const { data: pages } = await http.get('content/tabs_pages', {
        fields: [{ tabs: [{ tabs_spaces: ['slug'] }] }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'TabsSpacePage',
        params: { slug: pages[0]?.tabs.tabs_spaces.slug[0] }
      }
    }
  }
}
