import { http } from '@inside-library/helpers/Http'

import { upcomingEventsDateFilters } from '@inside-events/constants'

const fetchSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'published_at',
        'introduction',
        'admin',
        'content_type',
        'slug',
        {
          users: {
            fields: [
              'uuid',
              'firstname',
              'lastname',
              'image',
              'email',
              { services: ['title'] }
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          events_categories: {
            fields: [
              'uuid',
              'title',
              {
                events: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'date',
                    'end_date',
                    'place',
                    'display_hours',
                    'content_type',
                    {
                      events_categories: {
                        fields: ['uuid', 'color'],
                        filters: { 'status:eq': 1 }
                      }
                    }
                  ],
                  filters: {
                    reverse: true,
                    limit: 4,
                    'status:eq': 1,
                    'published_at:lte': 'now()',
                    ...upcomingEventsDateFilters
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          pages_categories: { fields: ['count'], filters: { reverse: true } }
        }
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchSimpleSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'published_at',
        'introduction',
        'admin',
        'content_type'
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchTabsSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/tabs_spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'published_at',
        'introduction',
        'admin',
        'content_type'
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchSpace, fetchSimpleSpace, fetchTabsSpace }
