<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class AddBuContentType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('business_units');

        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'business_units',
            options: [
                'name' => 'business_units',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => true,
                'required' => false,
                'title' => [
                    'fr' => 'Business Unit',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['business_units'],
                    'cardinality' => 1,
                ],
            ],
            weight: 11
        );

        collect(['services', 'directions'])->each(
            fn ($contentType) => $this->getBridge()?->contentTypeCreateOrUpdateField(
                type: $contentType,
                fieldName: 'code',
                options: [
                    'name' => 'code',
                    'searchable' => false,
                    'translatable' => true,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => 1,
                    'title' => [
                        'fr' => 'Référence d\'import',
                    ],
                    'widget' => [
                        'hidden' => true,
                    ],
                    'type' => BridgeContentType::TEXT_FIELD,
                    'settings' => [
                        'max_length' => 255,
                        'is_ascii' => false,
                        'case_sensitive' => false,
                        'cardinality' => 1,
                    ]
                ],
                weight: 1
            )
        );

        $this->call('models:rebuild');
        $this->finishUp();
    }
}
