<?php

return [
    'files' => [
        'zura' => [
            'path' => env('CSV_USERS_PATH', __DIR__.'/../../../../imports/import.csv'),
            'separator' => env('CSV_USERS_SEPARATOR', ';'),
            'fields' => [
                'name' => 'email',
                'mail' => 'email',
                'lastname' => 'surname',
                'firstname' => 'givenName',
                'location' => 'physicalDeliveryOfficeName',
                'services' => fn (array $record) => reference('services')
                    ->identifiedBy('code')
                    ->from(str($record['department'].'')->ucfirst())
                    ->get(),
                'directions' => fn (array $record) => reference('directions')
                    ->identifiedBy('code')
                    ->from(str($record['EmployeeType'].'')->ucfirst())
                    ->get(),
                'status' => fn () => true,
                'is_maintenance' => fn () => false,
            ],
        ],
    ],
];
