<?php

use Illuminate\Support\Arr;

return [
    'sync_attributes' => [
        'mail' => fn (mixed $user) => Arr::first($user->userPrincipalName, default: $user->mail),
        'name' => fn (mixed $user) => Arr::first($user->userPrincipalName, default: $user->mail),
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'function' => 'jobTitle',
        'business_units' => fn (mixed $user) => reference('business_units')
            ->identifiedBy('code')
            ->from(str($user->companyName.'')->lower()->ucfirst())
            ->get(),
        'services' => fn (mixed $user) => reference('services')
            ->identifiedBy('code')
            ->from($user->department)
            ->from(str($user->department.'')->lower()->ucfirst())
            ->get(),
        'directions' => fn (mixed $user) => reference('directions')
            ->identifiedBy('code')
            ->from(str($user->officeLocation.'')->lower()->ucfirst())
            ->get(),
        'status' => fn () => true,
        'is_maintenance' => fn (mixed $user) => $user->mail === 'iinside@azuragroupe.onmicrosoft.com',
    ],
    'custom_attributes' => [
    ],
];
