<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class CreateDirectionsContentType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('directions');

        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'directions',
            options: [
                'name' => 'directions',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => true,
                'required' => false,
                'title' => [
                    'fr' => 'Direction',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['directions'],
                    'cardinality' => 1,
                ],
            ],
            weight: 10
        );

        $this->finishUp();
    }
}
