<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

final class SeedDefaulttools extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        Artisan::call('models:rebuild');

        $tools = [
            'Outil 1',
            'Outil 2',
            'Outil 3',
            'Outil 4',
            'Outil 5',
        ];

        $bridgeContent = new BridgeContent();
        $tools = collect($tools)->map(fn (string $title) => $this->getTool($bridgeContent, $title));

        $this->getBridge()?->contentTypeCreateOrUpdateField('users', 'tools', [
            'default' => $tools->pluck('uuid_host')->map(fn (string $uuid_host) => ['target_uuid' => $uuid_host])->all(),
        ]);

        Users::each(function (Users $user) use ($bridgeContent, $tools) {
            $defaultTools = $tools->pluck('uuid');

            $bridgeContent->contentUpdate('users', [
                'uuid' => $user->uuid,
                'tools' => $user->tools->pluck('uuid')->merge($defaultTools)->filter()->unique()->values()->all(),
            ]);
        });

        $this->finishUp();
    }

    private function getTool(BridgeContent $bridge, string $title): Tools
    {
        $tool = Tools::where(['title' => $title])->first();

        if (! $tool instanceof Tools) {
            $uuid = $bridge->contentInsert('tools', ['title' => $title]);
            $tool = Tools::findOrFail($uuid);
        }

        return $tool;
    }
}
