<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;

final class SeedCustoms extends Migration
{
    public function up(): void
    {
        Artisan::call('models:rebuild');

        $customs = collect([
            [
                'custom_slug' => 'news',
                'redirection_page' => 'NewsListingPage',
                'title' => 'Actualités',
            ],
            [
                'custom_slug' => 'calendar',
                'redirection_page' => 'EventsCalendarPage',
                'title' => 'Événements',
            ],
            [
                'custom_slug' => 'directory',
                'redirection_page' => 'DirectoryPage',
                'title' => 'Nos équipes ont du talent',
            ],
            [
                'custom_slug' => 'tools',
                'redirection_page' => 'ToolsPage',
                'title' => 'Outils',
            ],
            [
                'custom_slug' => 'faq',
                'redirection_page' => 'FAQListingPage',
                'title' => 'FAQ',
            ],
            [
                'custom_slug' => 'quiz',
                'redirection_page' => 'QuizListingPage',
                'title' => 'Quiz',
            ],
        ]);

        $bridge = new BridgeContent();

        $customs->each(function (array $custom) use ($bridge) {
            $existing = Custom::where('redirection_page', $custom['redirection_page'])->first();

            if ($existing instanceof Custom) {
                $custom['uuid'] = $existing->uuid;
                return $bridge->contentUpdate('custom', $custom, true);
            }

            return $bridge->contentInsert('custom', $custom, true, true);
        });
    }
}
