<?php

namespace Inside\WORK\Providers;

use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Reaction\Events\ReactionSubscribedEvent;
use Inside\Reaction\Events\ReactionUnsubscribedEvent;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Inside\WORK\Listeners\EventTranslatedListener;
use Inside\WORK\Listeners\EventUserRegisteredListener;
use Inside\WORK\Listeners\EventUserUnregisteredListener;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

class ServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        ReactionSubscribedEvent::class => [
            EventUserRegisteredListener::class,
        ],
        ReactionUnsubscribedEvent::class => [
            EventUserUnregisteredListener::class,
        ],
        ContentFullyInsertedEvent::class => [
            EventTranslatedListener::class,
        ],
    ];

    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/azuread.php', 'azuread');
            $this->mergeConfigFrom(__DIR__.'/../../config/xlsx.php', 'xlsx');
            $this->mergeConfigFrom(__DIR__.'/../../config/csv.php', 'csv');
            $this->mergeConfigTo(__DIR__ . '/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__ . '/../../config/statistics.php', 'statistics');
            $this->mergeConfigTo(__DIR__ . '/../../config/permission.php', 'permission');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
