<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class TranslateWorkContentTitles extends Migration
{
    private const FIELDS = [
        'external_notifications' => [
            'fr' => 'Notification externe',
            'de' => 'Externe Benachrichtigung',
        ],
        'courses' => [
            'fr' => "Formation",
            "de" => "Ausbildung"
        ],
        'courses_categories' => [
            'fr' => "Catégorie de formation",
            "de" => "Trainingskategorie"
        ],
        'courses_lessons' => [
            'fr' => "Leçon de formation",
            "de" => "Trainingsstunde"
        ],
        'courses_chapters' => [
            'fr' => "Chapitre de formation",
            "de" => "Schulungskapitel"
        ],
        'courses_quizzes' => [
            'fr' => "Quizz de formation",
            "de" => "Trainingsquiz"
        ],
        'tabs' => [
            'fr' => "Onglet",
            "de" => "Tab"
        ],
        'tabs_spaces' => [
            'fr' => "Espace à onglet",
            "de" => "Tab-Leerzeichen"
        ],
        'tabs_pages' => [
            'fr' => "Sous page onglet",
            "de" => "Unter Registerkarte Seite"
        ]
    ];

    public function up(): void
    {
        $bridge = new BridgeContentType();

        collect(self::FIELDS)
            ->each(fn ($titles, $field) => $bridge->updateContentTypeOptions(
                type: $field,
                options: [
                    'translatable' => true,
                    'title' => $titles,
                ]
            ));
        Artisan::call('index:rebuild');
    }
}
