<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class TranslateWorkTabsPages extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $fields = [
            [
                'name' => 'tabs',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => true,
                'weight' => 0,
                'title' => [
                    'fr' => 'Onglets',
                    'de' => 'Tab',
                ],
                'description' => [
                    'fr' => 'Choix du regroupement de l\'onglet dans lequel il doit remonter',
                    'de' => 'Auswahl der Gruppierung der Registerkarte, in der es nach oben gehen soll',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 0,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['tabs'],
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'weight',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => 'Ordre d\'affichage',
                    'de' => 'OAnzeigereihenfolge',
                ],
                'description' => [
                    'fr' => 'Le chiffre le plus bas remonte en 1er',
                    'de' => 'Die niedrigste Zahl steigt zuerst auf',
                ],
                'widget' => [
                    'type' => BridgeContentType::NUMBER_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::INTEGER_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'content',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => true,
                'weight' => 2,
                'title' => [
                    'fr' => 'Contenu',
                    'de' => 'Inhalt',
                ],
                'description' => [
                    'fr' => 'Sélectionnez les différents types de paragraphes que vous voulez faire remonter sur la page',
                    'de' => 'Wählen Sie die verschiedenen Arten von Absätzen aus, die Sie auf der Seite nach oben verschieben möchten',
                ],
                'widget' => [
                    'type' => BridgeContentType::SECTION_WIDGET,
                    'settings' => [
                        'title' => 'Paragraphe',
                        'title_plural' => 'Paragraphes',
                        'edit_mode' => 'open',
                        'add_mode' => 'dropdown',
                        'form_display_mode' => 'default',
                        'default_paragraph_type' => '',
                    ],
                    'weight' => 2,
                ],
                'type' => BridgeContentType::SECTION_FIELD,
                'settings' => [
                    'target_type' => [
                        'text',
                        'text_two_columns',
                        'text_with_image',
                        'separator',
                        'file',
                        'slider',
                        'image',
                        'video',
                        'map',
                        'accordion',
                        'call_to_action',
                        'button',
                        'html',
                        'tweet',
                    ],
                    'cardinality' => -1,
                ],
            ],
        ];
        $options = [
            'name' => 'tabs_pages',
            'translatable' => true,
            'searchable' => true,
            'global_searchable' => false,
            'aliasable' => false,
            'permissible' => false,
            'categorizable' => false,
            'listing_type' => 'content',
            'title' => [
                'fr' => 'Sous Page Onglet',
                'de' => 'Unter Registerkarte Seite',
            ],
        ];

        $bridge->contentTypeUpdate(
            type: 'tabs_pages',
            options: $options,
            fields: $fields,
            entityTypeId: 'node'
        );

        Artisan::call('index:rebuild');
    }
}
