<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateCoursesLessons extends Migration
{
    private const FIELDS = [
        'content' => [
            'title' => [
                'fr' => 'Contenu',
                'de' => 'Inhalt',
            ],
        ],
        'courses_chapters' => [
            'title' => [
                'fr' => 'Chapitre Formation',
                'de' => 'Schulungskapitel',
            ],
        ],
        'weight' => [
            'title' => [
                'fr' => 'Ordre de comparution',
                'de' => 'Reihenfolge des Erscheinens',
            ]
        ]
    ];

    public function up(): void
    {
        $bridge = new BridgeContentType();
        try {
            collect(self::FIELDS)->each(fn ($fieldOptions, $fieldName) => $bridge->updateFieldOptions(
                type: 'courses_lessons',
                fieldName: $fieldName,
                options: $fieldOptions
            ));
        } catch (Exception $e) {
            return;
        }
    }
}
