<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

final class CreateTabsContentTypes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('tabs');
        $this->migrateContent('tabs_pages');
        $this->getBridge()?->contentTypeDeleteField('node', 'tabs_spaces', 'tabs_spaces_categories');
        $this->getBridge()?->contentTypeDelete('tabs_spaces_categories');
        $this->finishUp();
    }
}
