<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Users;

class UpdateSitesFieldForUsers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();
        $bridgeContentType->contentTypeUpdate('sites', [
            'title' => [
                'fr' => 'Equipe',
                'de' => 'LOKALISIERUNG',
            ]
        ]);
        $bridgeContentType->contentTypeCreateOrUpdateField('users', 'sites', [
            'title' => [
                'fr' => 'Equipe',
                'de' => 'LOKALISIERUNG',
            ]
        ]);
        $bridgeContentType->switchCardinalityFromUnaryToMultiple('users', 'sites');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
    }
}
