<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;

final class SeedCustoms extends Migration
{
    public function up(): void
    {
        Artisan::call('models:rebuild');

        $customs = collect([
            [
                'custom_slug' => 'news',
                'redirection_page' => 'NewsListingPage',
                'title' => [
                    'fr' => 'Actualités',
                    'de' => 'Nachrichten',
                ],
            ],
            [
                'custom_slug' => 'tools',
                'redirection_page' => 'ToolsPage',
                'title' => [
                    'fr' => 'Outils',
                    'de' => 'Werkzeuge',
                ],
            ],
            [
                'custom_slug' => 'calendar',
                'redirection_page' => 'EventsCalendarPage',
                'title' => [
                    'fr' => 'Événements',
                    'de' => 'Veranstaltungen',
                ],
            ],
            [
                'custom_slug' => 'ged',
                'redirection_page' => 'GedPage',
                'title' => [
                    'fr' => 'Bibliothèque de ressources',
                    'de' => 'Ressourcenbibliothek',
                ],
            ],
            [
                'custom_slug' => 'directory',
                'redirection_page' => 'DirectoryPage',
                'title' => [
                    'fr' => 'Annuaire des New Workers',
                    'de' => 'Verzeichnis der New Workers',
                ],
            ],
            [
                'custom_slug' => 'newcomers',
                'redirection_page' => 'NewcomersListingPage',
                'title' => [
                    'fr' => 'Nouveaux arrivants',
                    'de' => 'Neulinge',
                ],
            ],
        ]);


        $locale = config('app.locale');
        $languages = collect(list_languages())->diff([$locale])->values();

        $bridge = new BridgeContent();

        $customs->each(function (array $custom) use ($bridge, $locale, $languages) {
            $original = $this->createOrUpdate($bridge, $custom, $locale);
            $original = Custom::findOrFail($original);
            $custom['uuid_host'] = $original->uuid_host;
            $languages->each(fn ($language) => $this->createOrUpdate($bridge, $custom, $language));
        });
    }

    private function createOrUpdate(BridgeContent $bridge, array $custom, string $language): ?string
    {
        $data = array_map(fn ($value) => $value[$language] ?? $value, $custom);
        $data['langcode'] = $language;

        $existing = Custom::query()
            ->where('redirection_page', $data['redirection_page'])
            ->where('langcode', $data['langcode'])
            ->first();

        if ($existing instanceof Custom) {
            $data['uuid'] = $existing->uuid;
            return $bridge->contentUpdate('custom', $data, true);
        }

        return $bridge->contentInsert('custom', $data, true, true);
    }
}
