<?php

return [
    'types'  => [
        'news'       => [
            'category' => 'news_categories',
            'comments' => true,
            'likes'    => true,
        ],
        'events'     => [
            'category' => 'events_categories',
            'comments' => true,
            'likes'    => true,
        ],
        'documents'  => [
            'category' => 'folders',
            'comments' => true,
            'likes'    => true,
        ],
        'forms'    => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'pages'    => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'tools'    => [
            'category' => 'tools_categories',
            'comments' => false,
            'likes'    => false,
        ],
        'tabs_spaces'    => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ]
    ],
    'export' => [
        'contents'       => [
            'headers'    => [
                'uuid'         => 'UUID',
                'content_type' => 'Content type',
                'title'        => 'Title',
                'edit'         => 'Edit link',
            ],
            'presenters' => [
                'edit' => function ($value, $model) {
                    return env('APP_URL') . '/edit/' . class_to_type($model) . '/' . $model->uuid;
                },
            ],
        ],
        'users'          => [
            'headers' => [
                'email'     => 'Mail address',
                'full_name' => 'Full name',
            ],
        ],
        'authentication' => [
            'headers' => [],
        ]
    ]
];
