<?php

namespace Inside\WORK\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Models\Contents\Events;
use Inside\Reaction\Events\ReactionUnsubscribedEvent;
use Inside\Reaction\Models\Reaction;

class EventUserUnregisteredListener implements ShouldQueue
{
    public function handle(ReactionUnsubscribedEvent $event): void
    {
        $reaction = $event->reaction;

        if (! $reaction->reactionable instanceof Events || $reaction->type !== 'register') {
            return;
        }

        collect(list_languages())
            ->reject(fn ($value) => $value === $reaction->reactionable->langcode)
            ->each(function (string $langcode) use ($reaction) {
                $eventTranslation = $reaction->reactionable->getTranslationIfExists($langcode);

                if ($eventTranslation->uuid === $reaction->reactionable->uuid) {
                    return;
                }

                Reaction::where([
                    'reactionable_uuid' => $eventTranslation->uuid,
                    'reactionable_type' => $reaction->reactionable_type,
                    'user_uuid' => $reaction->user_uuid,
                    'type' => $reaction->type,
                    'langcode' => $langcode,
                ])->delete();
            });
    }
}
