<?php

namespace Inside\WORK\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Models\Contents\Events;
use Inside\Reaction\Events\ReactionSubscribedEvent;
use Inside\Reaction\Models\Reaction;

class EventUserRegisteredListener implements ShouldQueue
{
    public function handle(ReactionSubscribedEvent $event): void
    {
        $reaction = $event->reaction;

        if (! $reaction->reactionable instanceof Events || $reaction->type !== 'register') {
            return;
        }

        collect(list_languages())
            ->reject(fn ($value) => $value === $reaction->reactionable->langcode)
            ->each(function (string $langcode) use ($reaction) {
                $eventTranslation = $reaction->reactionable->getTranslationIfExists($langcode);

                if ($eventTranslation->uuid === $reaction->reactionable->uuid) {
                    return;
                }

                Reaction::firstOrCreate([
                    'reactionable_uuid' => $eventTranslation->uuid,
                    'reactionable_type' => $reaction->reactionable_type,
                    'user_uuid' => $reaction->user_uuid,
                    'type' => $reaction->type,
                    'langcode' => $langcode,
                ]);
            });
    }
}
