<?php

namespace Inside\WORK\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Models\Contents\Events;
use Inside\Reaction\Models\Reaction;

class EventTranslatedListener
{
    public function handle(ContentFullyInsertedEvent $event): void
    {
        $model = $event->model;

        if (! $model instanceof Events) {
            return;
        }

        collect(list_languages())
            ->reject(fn ($value) => $value === $model->langcode)
            ->each(function (string $langcode) use ($model) {
                $eventTranslation = $model->getTranslationIfExists($langcode);

                if ($eventTranslation->uuid === $model->uuid) {
                    return;
                }

                Reaction::query()
                    ->where('type', 'register')
                    ->where('reactionable_uuid', $eventTranslation->uuid)
                    ->where('reactionable_type', get_class($eventTranslation))
                    ->pluck('user_uuid')
                    ->each(fn (string $userUuid) => Reaction::firstOrCreate([
                        'type' => 'register',
                        'reactionable_uuid' => $model->uuid,
                        'reactionable_type' => get_class($model),
                        'user_uuid' => $userUuid,
                        'langcode' => $model->langcode,
                    ]));
            });
    }
}
