<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Users;
use Inside\Notify\Models\Notification;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;

final class AddNotificationViaMailOnComments extends Migration
{
    public function up(): void
    {
        $notificationTypes = [];

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'email',
                'default'   => true,
                'event'     => 'Inside\Content\Events\CommentCreatedEvent',
                'model'     => 'Inside\Content\Models\Contents\Comments',
                'action'    => 'contentCommented',
                'type'      => 'global',
                'condition' => 'parent_type:news,events|author:CURRENT_USER',
                'multiple'  => true,
                'language'  => false,
                'profile'   => true,
            ],
            [
                'data'      => [
                    'title'       => 'notifications.create.comment.content.mail.title',
                    'description' => 'notifications.create.comment.content.<content_type>.mail.text',
                    'mail'        => [
                        'subject'    => 'notifications.create.comment.content.mail.title',
                        'text'       => 'notifications.create.comment.content.<content_type>.mail.text',
                        'buttonText' => 'notifications.create.comment.content.mail.buttonText',
                    ],
                ],
            ]
        );

        // Someone answer someone else comment
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'email',
                'default'   => true,
                'event'     => 'Inside\Content\Events\CommentCreatedEvent',
                'model'     => 'Inside\Content\Models\Contents\Comments',
                'action'    => 'commentCommented',
                'type'      => 'global',
                'condition' => 'author:CURRENT_USER',
                'multiple'  => true,
                'language'  => false,
                'profile'   => true,
            ],
            [
                'data'      => [
                    'title'       => 'notifications.create.comment.content.mail.title',
                    'description' => 'notifications.create.comment.content.<content_type>.mail.text',
                    'mail'        => [
                        'subject'    => 'notifications.create.comment.content.mail.title',
                        'text'       => 'notifications.create.comment.content.<content_type>.mail.text',
                        'buttonText' => 'notifications.create.comment.content.mail.buttonText',
                    ],
                ],
            ]
        );

        foreach ($notificationTypes as $notificationType) {
            /**  @var NotificationType $notificationType */
            Users::all()->each(
                function ($user) use ($notificationType) {
                    NotificationSubscriber::firstOrCreate(
                        [
                            'user_uuid'            => $user->uuid,
                            'notification_type_id' => $notificationType->id,
                        ]
                    );
                }
            );
        }
    }
}
