<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateCoursesQuizzes extends Migration
{
    private const FIELDS = [
        'content' => [
            'title' => [
                'fr' => 'Questions',
                'de' => 'Fragen',
            ],
        ],
        'courses_chapters' => [
            'title' => [
                'fr' => 'Chapitre Formation',
                'de' => 'Schulungskapitel',
            ],
        ],
        'description' => [
            'title' => [
                'fr' => 'Description',
                'de' => 'Beschreibung',
            ]
        ],
        'failure_text' => [
            'title' => [
                'fr' => "Textes en cas d'erreur",
                'de' => 'Text im Fehlerfall',
            ],
            'description' => [
                'fr' => "Ce texte s'affiche si l'utilisateur n'a pas atteint le nombre de bonnes réponses requis.",
                'de' => 'Dieser Text wird angezeigt, wenn der Benutzer die erforderliche Anzahl von korrekten Antworten nicht erreicht hat.',
            ],
        ],
        'min_valid_values' => [
            'title' => [
                'fr' => "Nombre de réponses valides obligatoires",
                'de' => 'Anzahl der obligatorischen gültigen Antworten',
            ],
            'description' => [
                'fr' => 'Il ne pourra pas valider cette étape',
                'de' => 'Er wird diesen Schritt nicht validieren können',
            ],
        ],
        'success_text' => [
            'title' => [
                'fr' => 'Texte en cas de réussite',
                'de' => 'Text im Erfolgsfall',
            ],
            'description' => [
                'fr' => "Ce texte s'affiche lorsque l'utilisateur a atteint le nombre de bonnes réponses requis.",
                'de' => 'Dieser Text wird angezeigt, wenn der Benutzer die erforderliche Anzahl von korrekten Antworten erreicht hat.',
            ],
        ],
        'weight' => [
            'title' => [
                'fr' => 'Ordre de comparution',
                'de' => 'Reihenfolge des Erscheinens',
            ],
            'description' => [
                'fr' => 'Le nombre inférieur augmentera',
                'de' => 'Die niedrigere Nummer wird nach oben gehen',
            ],
        ],
    ];

    public function up(): void
    {
        $bridge = new BridgeContentType();
        try {
            collect(self::FIELDS)->each(fn ($fieldOptions, $fieldName) => $bridge->updateFieldOptions(
                type: 'courses_quizzes',
                fieldName: $fieldName,
                options: $fieldOptions
            ));
        } catch (Exception $e) {
            return;
        }
    }
}
