<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class MakeFormsFieldsTranslatable extends Migration
{
    private const FIELDS = [
        'image',
        'admin_roles',
        'anonym',
        'has_status',
        'only_one_reply',
        'show_my_replies',
        'show_trends_user'
    ];
    public function up(): void
    {
        $bridge = new BridgeContentType();
        try {
            collect(self::FIELDS)->each(fn ($field) => $bridge->updateFieldOptions(
                type: 'forms',
                fieldName: $field,
                options: [
                    'translatable' => true,
                ]
            ));
        } catch (Exception $e) {
            return;
        }
    }
}
