<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

final class UpdateBlocksAndCardLinksContentTypesTitles extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        collect([
            [
                'type' => 'blocks',
                'title' => [
                    'fr' => 'Bloc',
                    'de' => 'Block',
                ],
            ],
            [
                'type' => 'cards_links',
                'title' => [
                    'fr' => 'Bloc image',
                    'de' => 'Block bild',
                ],
            ],
        ])->each(fn ($contentToUpdate) => $bridge->contentTypeUpdate($contentToUpdate['type'], ['title' => $contentToUpdate['title']]));
    }
}
