<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class SetInputsFormsFieldsAsTranslatable extends Migration
{
    public function up(): void
    {
        $fields = ['inputs', 'forms_introduction'];

        $bridge = new BridgeContentType();

        foreach ($fields as $fieldName) {
            $bridge->updateFieldOptions('forms', $fieldName, [
                'translatable' => true
            ]);
        }
    }
}
