<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Events;
use Inside\Reaction\Models\Reaction;

final class SyncEventsRegistrations extends Migration
{
    public function up(): void
    {
        $languages = collect(list_languages());
        Events::each(function (Events $event) use ($languages) {
            $registered = Reaction::query()
                ->where('type', 'register')
                ->where('reactionable_uuid', $event->uuid)
                ->where('reactionable_type', get_class($event))
                ->where('langcode', $event->langcode)
                ->pluck('user_uuid');

            $languages
                ->reject(fn (string $langcode) => $langcode === $event->langcode)
                ->each(function (string $langcode) use ($event, $registered) {
                    $eventTranslation = $event->getTranslationIfExists($langcode);

                    if ($eventTranslation->uuid === $event->uuid) {
                        return;
                    }

                    $registered->each(fn (string $userUuid) => Reaction::firstOrCreate([
                        'type' => 'register',
                        'reactionable_uuid' => $eventTranslation->uuid,
                        'reactionable_type' => get_class($eventTranslation),
                        'user_uuid' => $userUuid,
                        'langcode' => $eventTranslation->langcode,
                    ]));
                });
        });
    }
}
