<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

final class UpdateUsersEditableFields extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $editableFields = [
            'attendance_days',
            'verbal_languages',
            'joining_date',
            'birthday',
        ];

        foreach ($editableFields as $editableField) {
            $this->getBridge()?->updateFieldOptions('users', $editableField, ['editable' => true]);
        }

        $this->finishUp();
    }
}
