<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

final class HideExternalNotifications extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeUpdate('external_notifications', [
            'listing_type' => 'hidden',
            'searchable' => false,
            'global_searchable' => false,
        ]);
        $this->finishUp();
    }
}
