<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'forms',
        'translatable' => true,
        'title' => [
            'fr' => 'Formulaires & sondages',
            'de' => 'Formulare und Umfragen',
        ],
    ],
    'fields' => [
        [
            "name" => "form_type",
            'type' => BridgeContentType::LIST_STRING_FIELD,
            'translatable' => true,
            "title" => [
                "fr" => "Quel type de contenu souhaitez-vous créer ? (case à cocher)",
                "de" => "Welchen Inhaltstyp möchten Sie erstellen? (Ankreuzfeld)",
            ],
            "description" => [
                "fr" => "Les sondages vous permettent de recueillir des avis / Les formulaires vous permettent de stocker des demandes",
                "de" => "Umfragen ermöglichen es Ihnen, Meinungen zu sammeln / Formulare ermöglichen es Ihnen, Anfragen zu speichern",
            ],
            'settings' => [
                'allowed_values' => [
                    'forms' => [
                        'fr' => 'Formulaire',
                        'de' => 'Formular',
                    ],
                    'surveys' => [
                        'fr' => 'Sondage',
                        'de' => 'Umfrage',
                    ],
                ],
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
        ],
        [
            "name" => "admin_roles",
            "title" => [
                "fr" => "Administrateurs",
                "de" => "Administratoren",
            ],
            "description" => [
                "fr" => "La liste des administrateurs",
                "de" => "Die Liste der Administratoren",
            ],
        ],
        [
            "name" => "anonym",
            "title" => [
                "fr" => "Les réponses sont anonymes",
                "de" => "Die Antworten sind anonym",
            ],
        ],
        [
            "name" => "aside_desc_admin",
            "title" => [
                "fr" => "Texte sur le bouton permettant d’accéder à toutes les demandes",
                "de" => "Text auf der Schaltfläche, um auf alle Anfragen zuzugreifen",
            ],
            "description" => [
                "fr" => "Exemple : Retrouvez ici les demandes des collaborateurs pour les gérer simplement",
                "de" => "Beispiel: Hier finden Sie die Anfragen der Mitarbeiter, um sie einfach zu verwalten",
            ],
        ],
        [
            "name" => "aside_desc_user",
            "title" => [
                "fr" => "Texte sur le bouton permettant d’accéder à son historique",
                "de" => "Text auf der Schaltfläche, um auf die eigene Geschichte zuzugreifen",
            ],
            "description" => [
                "fr" => "Exemple : vous pouvez retrouver l’historique de vos demandes et consulter leur avancée",
                "de" => "Beispiel: Sie können Ihren Anfrageverlauf hier einsehen und den Fortschritt überprüfen",
            ],
        ],
        [
            "name" => "forms_introduction",
            "title" => [
                "fr" => "Introduction",
                "de" => "Einführung",
            ],
            "description" => [
                "fr" => "Ce paragraphe vous permet de présenter le sondage ou le formulaire",
                "de" => "Dieser Absatz ermöglicht es Ihnen, die Umfrage oder das Formular zu präsentieren",
            ],
        ],
        [
            "name" => "has_status",
            "title" => [
                "fr" => "Les demandes des utilisateurs doivent être validées par les administrateurs",
                "de" => "Die Anfragen der Benutzer müssen von den Administratoren bestätigt werden",
            ],
            "description" => [
                "fr" => "Demandes avec statut de validation par les administrateurs",
                "de" => "Anfragen mit Bestätigungsstatus durch Administratoren",
            ],
        ],
        [
            "name" => "image",
            "title" => [
                "fr" => "Bannière",
                "de" => "Banner",
            ],
            "description" => [
                "fr" => "Cette image s’affiche sur toute la largeur",
                "de" => "Dieses Bild wird über die gesamte Breite angezeigt",
            ],
        ],
        [
            "name" => "inputs",
            "title" => [
                "fr" => "Préparez les champs",
                "de" => "Bereiten Sie die Felder vor",
            ],
            "description" => [
                "fr" => "Vous pouvez créer autant de champs que souhaité",
                "de" => "Sie können so viele Felder erstellen, wie Sie möchten",
            ],
        ],
        [
            "name" => "only_one_reply",
            "title" => [
                "fr" => "Les utilisateurs ne peuvent répondre qu’une seule fois",
                "de" => "Die Benutzer können nur einmal antworten",
            ],
        ],
        [
            "name" => "show_my_replies",
            "title" => [
                "fr" => "Les utilisateurs peuvent consulter l’historique de leurs demandes",
                "de" => "Die Benutzer können ihren Anfrageverlauf einsehen",
            ],
            "description" => [
                "fr" => "Utile principalement pour les formulaires",
                "de" => "Hauptsächlich für Formulare nützlich",
            ],
        ],
        [
            "name" => "show_trends_user",
            "title" => [
                "fr" => "Après avoir répondu, les utilisateurs peuvent voir la moyenne des autres répondants",
                "de" => "Nachdem die Benutzer geantwortet haben, können sie den Durchschnitt der anderen Teilnehmer sehen",
            ],
            "description" => [
                "fr" => "Utile principalement pour les sondages",
                "de" => "Hauptsächlich für Umfragen nützlich",
            ],
        ],
    ],
];
