<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'blocks',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Bloc',
            'de' => 'Block Bild',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Image',
                'de' => 'Bild',
            ],
            'description' => [
                'fr' => 'L\'icone remontera sur la gauche du bloc, si une image est complétée l\'icone ne remontera pas',
                'de' => 'Das Symbol wird auf der linken Seite des Blocks angezeigt, wenn ein Bild fertig ist, wird das Symbol nicht angezeigt',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'icon',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Icone',
                'de' => 'Symbol',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'background_color',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Couleur de fond',
                'de' => 'Hintergrundfarbe',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'dark_mode',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Dark mode',
                'de' => 'Dark mode',
            ],
            'description' => [
                'fr' => 'Si le dark mode est activé, le texte et l\'icone seront blancs',
                'de' => 'Wenn der Dunkelmodus aktiviert ist, sind der Text und das Symbol weiß',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
        [
            'name' => 'link',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 4,
            'title' => [
                'fr' => 'Lien',
                'de' => 'Verknüpfung',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                'settings' => [],
                'weight' => 4,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'link_label',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Texte du lien',
                'de' => 'Link Text',
            ],
            'description' => [
                'fr' => 'Si aucun texte n\'est rempli alors le bloc complet sera cliquable',
                'de' => 'Wenn kein Text ausgefüllt ist, ist der komplette Block anklickbar',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 5,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 6,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'de' => 'Reihenfolge des Erscheinens',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'de' => 'Die niedrigste Zahl steigt in 1.',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 6,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
    ],
];
