<?php

declare(strict_types=1);

use Inside\Host\Bridge\BridgeContent;

return [
    'files' => [
        'work' => [
            'path' => env('XLSX_USERS_PATH', __DIR__.'/../../../../imports/users.xlx'),
            'fields' => [
                'name' => 'adresse email',
                'mail' => 'adresse email',
                'firstname' => fn (array $record) => ucwords(trim($record['prenom'])),
                'lastname' => fn (array $record) => ucwords(trim($record['nom'])),
                'function' => fn (array $record) => trim($record['fonction']) ?: null,
                'phone' => fn (array $record) => trim($record['fixe']) ?: null,
                'mobile_phone' => fn (array $record) => trim($record['mobile']) ?: null,
                'sites' => fn (array $record) => reference('sites')->from($record['site'])->get(),
                'attendance_days' => fn (array $record) => str($record['jours de présence'] ?? '')
                    ->after('Jours de présence :')
                    ->trim()
                    ->toString() ?: null,
                'sector' => fn (array $record) => trim($record['secteur']) ?: null,
                'status' => fn () => 1,
            ],
            'original_fields' =>  [
                'adresse email' => 'mail',
                'prenom' => 'firstname',
                'nom' => 'lastname',
                'fonction' => 'word',
                'fixe' => 'word',
                'mobile' => 'word',
                'site' => 'word',
                'jours de présence' => 'word',
                'secteur' => 'word',
            ],
        ],
    ],
];
