import SpacesPage from '../pages/spaces/SpacesPage'
import SpacesPagesPage from '../pages/spaces/SpacesPagesPage'

import TabSpacesPage from '../pages/tab-spaces/TabSpacesPage'

import {
  fetchSpacesPage,
  fetchSpacesPagesPage,
  fetchTabSpacesPage
} from '../fetch/spaces'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false
    }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    },
    meta: { disabled: false }
  },
  {
    name: 'TeamPage',
    meta: { disabled: false }
  },
  {
    name: 'SpacesPage',
    path: '/espaces/:slug',
    component: withFetch(SpacesPage, { size: 'xxl' })(fetchSpacesPage),
    meta: { content: 'spaces' }
  },
  {
    name: 'SpacesPagesPage',
    path: '/espaces/:slug/pages',
    component: withFetch(SpacesPagesPage, { size: 'xxl' })(
      fetchSpacesPagesPage
    ),
    meta: { content: 'spaces' }
  },
  {
    name: 'TabSpacesPage',
    path: '/espaces-onglet/:slug/pages',
    component: withFetch(TabSpacesPage, { size: 'xxl' })(fetchTabSpacesPage),
    meta: { content: 'tab_spaces' }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
