import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: ({ data }) => {
      return {
        name: 'SpacesPage',
        params: { slug: data.slug[0] }
      }
    }
  },
  pagesCategories: {
    fields: [{ spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.spaces.slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.spaces.slug[0] }
    }),
    globalSearch: async ({ data }) => {
      const { data: Space } = await http.get('content/pages_categories', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SpacesPagesPage',
          params: {
            slug: Space[0].spaces.slug[0]
          }
        }
      }
    }
  },
  spacesPages: {
    fields: ['uuid', { pages_categories: [{ spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'SpacesPagesPage',
      params: {
        slug: data.pages_categories.spaces.slug[0]
      },
      query: { page: data.uuid }
    }),
    delete: ({ data }) => ({
      name: 'SpacesPage',
      params: {
        slug: data.pages_categories.spaces.slug[0]
      }
    }),
    globalSearch: async ({ data }) => {
      const { data: pagesCategories } = await http.get('content/spaces_pages', {
        fields: ['uuid', { pages_categories: ['uuid', 'title'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      const { data: Space } = await http.get('content/pages_categories', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': pagesCategories[0].pages_categories.uuid }
      })

      return {
        route: {
          name: 'SpacesPagesPage',
          params: {
            slug: Space[0].spaces.slug[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  },
  tabSpaces: {
    add: ({ data }) => {
      return {
        name: 'TabSpacesPage',
        params: { slug: data.slug[0] }
      }
    }
  },
  tabPagesCategories: {
    fields: [{ tab_spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'TabSpacesPage',
      params: { slug: data.tab_spaces.slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'TabSpacesPage',
      params: { slug: data.tab_spaces.slug[0] }
    }),
    globalSearch: async ({ data }) => {
      const { data: Space } = await http.get('content/tab_pages_categories', {
        fields: ['uuid', { tab_spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'TabSpacesPage',
          params: {
            slug: Space[0].tab_spaces.slug[0]
          }
        }
      }
    }
  },
  tabSpacesPages: {
    fields: ['uuid', { tab_pages_categories: [{ tab_spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'TabSpacesPage',
      params: {
        slug: data.tab_pages_categories.tab_spaces.slug[0]
      },
      query: { page: data.uuid }
    }),
    delete: ({ data }) => ({
      name: 'TabSpacesPage',
      params: {
        slug: data.tab_pages_categories.tab_spaces.slug[0]
      }
    }),
    globalSearch: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/tab_spaces_pages',
        {
          fields: ['uuid', { tab_pages_categories: ['uuid', 'title'] }],
          filters: { 'uuid:eq': data.uuid }
        }
      )

      const { data: Space } = await http.get('content/tab_pages_categories', {
        fields: ['uuid', { tab_spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': pagesCategories[0].tab_pages_categories.uuid }
      })

      return {
        route: {
          name: 'TabSpacesPage',
          params: {
            slug: Space[0].tab_spaces.slug[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  }
}
