import { markRaw } from 'vue'
import Google from '@inside-auth/components/login/extra-component/Google'

const origin = new URL(
  process.env.NODE_ENV === 'development'
    ? JSON.parse(process.env.GLOBAL).localURL
    : window.location
).origin

export default {
  globals: {
    calendarExportTypes: [
      {
        type: 'google',
        label: 'Google'
      },
      {
        type: 'ics',
        label: 'iCalendar'
      }
    ]
  },
  'inside-auth': {
    extraComponent: {
      is: markRaw(Google),
      link: `${origin}/google/login`
    }
  },
  'inside-events': {
    calendarImportEnabled: true
  },
  'inside-layouts': {
    sizeMenuItems: 'l'
  },
  'inside-news': {
    bookmarkEnabled: false
  },
  'inside-users': {
    shortcuts: {
      max: 6,
      readonlyCount: 1
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' }
      ]
    }
  }
}
