<?php

namespace Inside\WEB2\Providers;

use Inside\Providers\ServiceProvider as BaseServiceProvider;
use Inside\WEB2\Console\ImportRSSNews;

class ServiceProvider extends BaseServiceProvider
{
    protected array $commands = [
        ImportRSSNews::class,
    ];

    /**
     * Boot
     */
    public function boot(): void
    {
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');
    }

    /**
     * Register
     */
    public function register(): void
    {
        $this->mergeConfigTo(__DIR__ . '/../../config/notify.php', 'notify');
        $this->mergeConfigTo(__DIR__ . '/../../config/importRSS.php', 'importRSS');
        $this->mergeConfigTo(__DIR__ . '/../../config/scheduler.php', 'scheduler');
        $this->mergeConfigTo(__DIR__ . '/../../config/google.php', 'google');
        $this->mergeConfigTo(__DIR__.'/../../config/import.php', 'import');
    }
}
