<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContentType;

class disableExternalNotifications extends Migration
{
    use HasConsole;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->updateContentTypeOptions('external_notifications', [
            'permissible' => false,
            'categorizable' => false,
            'listing_type' => 'hidden',
        ]);

        $this->writeln('Rebuilding models and user index');
        Artisan::call('models:rebuild');
        Artisan::call('index:rebuild', ['--type' => 'users']);
    }

    public function down(): void
    {
    }
}
