<?php

return [
    'client_id'                => env('GOOGLE_CLIENT_ID'),
    'client_secret'            => env('GOOGLE_CLIENT_SECRET'),
    'service_account_name'     => env('GOOGLE_SERVICE_ACCOUNT_NAME'),
    'service_account_key_path' => env('GOOGLE_SERVICE_ACCOUNT_KEY_PATH'),
    'scopes'                   => [
        'https://www.googleapis.com/auth/admin.directory.user.readonly',
        'https://www.googleapis.com/auth/admin.directory.group.readonly',
    ],
    'sync_attributes'          => [
        'email'     => 'getPrimaryEmail',
        'name'      => 'getPrimaryEmail',
        'firstname' => function (\Google_Service_Directory_User $user, $bridge) {
            $name = $user->getName();

            return $name['givenName'];
        },
        'lastname'  => function (\Google_Service_Directory_User $user, $bridge) {
            $name = $user->getName();

            return $name['familyName'];
        },
    ],
    'discovering_attribute'    => 'getPrimaryEmail',
];
