<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

class AddWifiAsFirstDefaultTools extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $wifiUuidHost = '636e5948-6b04-4c67-87d9-0b92de0efb24';

        $locale = config('app.locale');
        $bridgeContent = new BridgeContent();

        if (Tools::where('uuid_host', $wifiUuidHost)->doesntExist()) {
            $bridgeContent->contentInsert('tools', [
                'uuid' => $wifiUuidHost,
                'langcode' => $locale,
                'title' => 'Wi-Fi',
                'tools_link' => 'https://www.google.com',
            ]);
        }

        $wifiTool = Tools::where('uuid_host', $wifiUuidHost)->firstOrFail();

        $default = Schema::getFieldOptions('users', 'tools');

        $this->getBridge()?->contentTypeCreateOrUpdateField('users', 'tools', [
            'title' => ['fr' => 'Mes accès rapides'],
            'default' => collect(array_merge([$wifiTool->uuid_host], $default['default']))
                ->map(fn ($uuid) => ['target_uuid' => $uuid])
                ->toArray(),
        ]);

        Users::each(function (Users $user) use ($bridgeContent, $wifiTool) {
            $userTools = $user->tools
                ->reject(fn (Tools $tool) => $tool->uuid === $wifiTool->uuid)
                ->prepend($wifiTool)
                ->slice(0, 6);

            try {
                $bridgeContent->contentUpdate('users', [
                    'uuid' => $user->uuid,
                    'tools' => $userTools->pluck('uuid')->all(),
                ]);
            } catch (Exception $exception) {
                $this->getConsole()->writeln("<error>Error on user $user->uuid</error>");
            }
        });

        $this->finishUp();
    }
}
