<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddEventsCategoriesToSpaces extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'spaces',
            'events_categories',
            [
                'name' => 'events_categories',
                'searchable' => false,
                'translatable' => false,
                'required' => false,
                'weight' => 5,
                'title' => [
                    'fr' => 'Catégorie(s) de l\'événement',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 5,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['events_categories'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ],
            5
        );
    }
}
