<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\WEB2\Console\ImportRSSNews;
use Inside\Content\Models\Contents\News;

class ImportV1News extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $json = file_get_contents(storage_path('../inside1News.json'));
        if (!$json) {
            throw new \Exception('le fichier inside1News.json n\'a pas été récupéré.');
        }

        $this->bootUp(__FILE__);
        $console = $this->getConsole();
        $bridgeType = new BridgeContentType();
        // for previous existing instances that have already run the global content groups migration
        $bridgeType->contentTypeCreateOrUpdateField(
            'news',
            'webedia_guid',
            [
                'name' => 'webedia_guid',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 6,
                'title' => [
                    'fr' => 'Webedia GUID'
                ],
                'description' => [
                    'fr' => 'Id de la news venant du  flux rss Webedia',
                ],
                'widget' => [
                    'hidden' => true,
                ],
                'type' => BridgeContentType::INTEGER_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => 0,
            ],
            6
        );

        Artisan::call('models:rebuild');
        $bridgeContent = new BridgeContent();
        $importer = new ImportRSSNews();

        $results = json_decode($json, true);
        foreach ($results as $result) {
            $imgPath = storage_path('../v1newsImg/' . $result['enclosure']);
            if (!file_exists($imgPath)) {
                $imgPath = back_path('resources/assets/img/logo.png');
            }
            $result['enclosure'] = $imgPath;
            if (News::where('webedia_guid', $result['guid'])->exists()) {
                continue;
            }
            $formated = $importer->prepareNews($result);
            $bridgeContent->contentInsert('news', $formated);
        }
    }
}
