<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContentType;

class disableOrganigram extends Migration
{
    use HasConsole;

    public function up(): void
    {
        $bridge = new BridgeContentType();
        $types = [
            'organizations',
            'organizations_categories',
            'organization_items',
        ];

        foreach ($types as $type) {
            $bridge->updateContentTypeOptions($type, [
                'permissible' => false,
                'categorizable' => false,
                'listing_type' => 'hidden',
            ]);
        }

        $this->writeln('Rebuilding models and user index');
        Artisan::call('models:rebuild');
        Artisan::call('index:rebuild', ['--type' => 'users']);
    }

    public function down(): void
    {
    }
}
