<?php

use Illuminate\Support\Str;

return [
    'postfilter' => function ($users) {
        return $users->reject(
            fn ($user) =>
            ! Str::startsWith(Str::lower($user->getOrgUnitPath()), env('WEB2_ORGUNITPATH_FILTER', '/webedia/france'))
            || Str::endsWith(Str::lower($user->getPrimaryEmail()), '@ext.webedia-group.com')
        );
    },
];
