import TabsSpacesListingPage from '../pages/tabs-spaces/TabsSpacesListingPage'
import { fetchTabsSpacesListingPage } from '../components/tabs-spaces'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: { authorFields: [] }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false
    }
  },
  {
    name: 'TabsSpacesListingPage',
    path: '/espaces-a-onglet/:slug',
    component: withFetch(TabsSpacesListingPage, {
      size: 'xxl',
      watch: true
    })(fetchTabsSpacesListingPage)
  },
  {
    name: 'TabsSpacePage',
    meta: { disabled: false }
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  }
]
