import { http } from '@inside-library/helpers/Http'

export const fetchTabsSpacesListingPage = async ({ $route }) => {
  try {
    const { data: spacesCategories } = await http.get(
      'content/spaces_categories',
      {
        fields: [
          'uuid',
          'admin',
          'title',
          'content_type',
          'banner',
          'introduction'
        ],
        filters: { 'slug:eq': $route.params.slug }
      }
    )

    return spacesCategories[0]
  } catch (err) {
    throw new Error(err)
  }
}
