<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\Users;

class AddDefaultQuickAccessForUtex extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();
        $bridgeContentType = new BridgeContentType();

        $toolsTitles = [
            "cse mutex" => 0,
            "m-work" => 1,
            "my dev'rh" => 2,
            'smart rh' => 3,
            "offres d'emploi mutex" => 4,
            "easy vista" => 5,
        ];

        $tools = Tools::query()
            ->whereIn('title', array_keys($toolsTitles))
            ->get()
            ->sortBy(fn ($tool) => $toolsTitles[strtolower($tool->title)]);

        $tools->each(
            fn ($tool) => $bridge->contentUpdate(
                type: 'tools',
                data: [
                    'uuid' => $tool->uuid,
                    'title' => $tool->title,
                    'weight' => $toolsTitles[strtolower($tool->title)]
                ]
            )
        );

        $bridgeContentType->contentTypeCreateOrUpdateField('users', 'tools', [
            'title' => ['fr' => 'Mes accès rapides'],
            'default' => $tools
                ->map(fn ($tool) => ['target_uuid' => $tool->uuid_host])
                ->toArray(),
        ]);

        Users::all()->each(fn ($user) => $bridge->updateReferenceFields(
            type: 'users',
            contentUuidHost: $user->uuid_host,
            data: [
                'tools' => $tools->pluck('uuid_host')
            ]
        ));
    }
}
