<?php

declare(strict_types=1);

use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use Inside\Content\Models\Contents\Users;

return [
    'preflight' => static function () {
        $filePath = config('csv.files.utex.crypted_path');
        $extractPath = config('csv.files.utex.path');
        $zipKey = config('csv.files.utex.zip_key');

        if (File::exists($filePath) && !empty($zipKey)) {
            $zip = new ZipArchive();
            $res = $zip->open($filePath);
            if ($res === true) {
                $zip->setPassword($zipKey);
                $zip->extractTo(sys_get_temp_dir());
                $zip->close();
            } else {
                throw new \Exception("Unable to open zip file at {$filePath} with key {$zipKey}");
            }
            if (! File::exists(config('csv.files.utex.path'))) {
                throw new \Exception("Unable to find CSV file {$extractPath} after extraction.");
            }
        } else {
            Log::error("CSV file not found at {$filePath} or ZIP key is empty.");
            throw new \Exception("CSV file not found at {$filePath} or ZIP key is empty.");
        }
    },
    'files' => [
        'utex' => [
            'zip_key' => env('CSV_USERS_ZIP_KEY', ''),
            'crypted_path' => env('CSV_USERS_CRYPTED_PATH'),
            'path' => sys_get_temp_dir() . '/' . env('CSV_USERS_FILENAME', 'importCollaborateursMutex.csv'),
            'separator' => env('CSV_USERS_SEPARATOR', ';'),
            'fields' => [
                'email' => 'office_email',
                'name' => 'office_email',
                'civilities' => 'civilite',
                'firstname' => 'prenom1',
                'lastname' => 'nom1',
                'function' => 'cemploi',
                'phone' => 'tel fixe pro',
                'mobile_phone' => 'tel portable pro',
                'registration_number' => 'mmat',
                'manager_number' => 'hmat',
                'directions' => fn (array $record) => reference('directions')
                    ->identifiedBy('code')
                    ->from($record['direction'])
                    ->get(),
                'departments' => fn (array $record) => reference('departments')
                    ->identifiedBy('code')
                    ->from($record['dpt'])
                    ->get(),
                'services' => fn (array $record) => reference('services')
                    ->identifiedBy('code')
                    ->from($record['service'])
                    ->get(),
                'locations' => fn (array $record) => reference('locations')
                    ->identifiedBy('code')
                    ->from($record['secteur'])
                    ->get(),
                'status' => fn () => true,
                'send_mail' => fn ($record): bool => Users::where('email', $record['office_email'])->doesntExist(),
            ],
        ],
    ],
    'postflight' => static function () {
        collect([
            config('csv.files.utex.crypted_path'),
            config('csv.files.utex.path'),
        ])->each(function (string $file) {
            if (File::exists($file)) {
                File::delete($file);
            }
        });
    },
];
