<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

final class UpdateContentFieldInPages extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'pages',
            fieldName: 'content',
            options: [
                'name' => 'content',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => true,
                'weight' => 1,
                'title' => [
                    'fr' => 'Contenu',
                ],
                'widget' => [
                    'type' => BridgeContentType::SECTION_WIDGET,
                    'settings' => [
                        'title' => 'Paragraphe',
                        'title_plural' => 'Paragraphes',
                        'edit_mode' => 'open',
                        'add_mode' => 'dropdown',
                        'form_display_mode' => 'default',
                        'default_paragraph_type' => '',
                    ],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::SECTION_FIELD,
                'settings' => [
                    'target_type' => [
                        'text',
                        'text_two_columns',
                        'text_with_image',
                        'separator',
                        'file',
                        'slider',
                        'image',
                        'video',
                        'map',
                        'accordion',
                        'call_to_action',
                        'button',
                        'html',
                        'tweet',
                        'fetched_contents',
                    ],
                    'cardinality' => -1,
                ],
            ],
        );
    }
}
