<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\ContentBlueprints;

class AddRequiredContentTypes extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $this->bootUp(__FILE__);
        ContentBlueprints::generateContent(contentType: 'faq_categories');
        ContentBlueprints::generateContent(contentType: 'faq_questions');
        ContentBlueprints::generateContent(contentType: 'flash_news');
        $this->call('models:rebuild');
        $this->finishUp();
    }
}
