const favoritesCategoriesConfig = {
  favorites_categories: {
    data: fields => fields.categories || [],
    style: 'tag'
  }
}

const trendsCategoriesConfig = {
  trends_categories: {
    data: fields => {
      try {
        if (fields.categories.trends_categories) {
          return fields.categories.trends_categories
        }

        return fields.categories || []
      } catch {
        return []
      }
    },
    style: 'tag'
  }
}

const relatedConfigs = {
  trends: trendsCategoriesConfig,
  favorites: favoritesCategoriesConfig
}

const configs = {
  trends: {
    ...trendsCategoriesConfig,
    categories: {
      data: fields => {
        if (fields.categories.trends_categories) {
          return fields.categories
        }
        return []
      }
    }
  },
  favorites: favoritesCategoriesConfig
}

export default {
  props: {
    content_type: {
      type: String
    }
  },
  data() {
    return {
      m_categoriesConfig: configs[this.content_type || this.$attrs.contentType],
      m_relatedCategoriesConfig:
        relatedConfigs[this.content_type || this.$attrs.contentType]
    }
  }
}
